#!/bin/bash -e
################################################################################
# This software has been developed by Advanced Driver Information Technology
# Copyright(c) 2019 Advanced Driver Information Technology GmbH,
# Advanced Driver Information Technology Corporation, Robert Bosch GmbH,
# Robert Bosch Car Multimedia GmbH and DENSO Corporation.
# All rights reserved
################################################################################

ADIT_TAG="dlt_i42"

cd ..
[[ -e dlt-daemon ]]
rm -rf dlt-daemon
sleep 1s
repo sync ./dlt-daemon
cd dlt-daemon

# Check if someone commited stuff that should not be there
git log --oneline | head -n1 | grep dlt_i || (
    echo "ERROR: Unexpected last commit" ;
    git show ;
    exit 1 )

git remote add upstream ssh://git@git-scm.adit-jv.com/gen3/dlt-daemon || true
git fetch upstream
git worktree add /tmp/dlt-daemon-upstream $ADIT_TAG

[[ -e automotive-dlt.pc.in ]]
rm -rf *
cp -r /tmp/dlt-daemon-upstream/* .

patch < ../dlt-meta/patches/0003-README.md-Add-copyright-information.patch

git add -A
git commit -s -m "dlt-daemon: upgrade to $ADIT_TAG"

rm -rf /tmp/dlt-daemon-upstream
git worktree prune
